param ($licenseXML)
if( test-connection wyday.com -Quiet ) {
    write-host "Got license XML file: $licenseXML"
    Select-Xml -Path $licenseXML -XPath '/SoftLock/products/upgradeCode' | ForEach-Object { $upgradeString = $_.Node.InnerXML
    $upgradeCode, $productCode, $productName = $upgradeString.Split(".")
    write-host "Got $productCode ( $productName )"
    Get-Service -Displayname "${productName}*floating license server" | Stop-Service -Force
    Sleep 2
    write-host "Deactivating product, ${productName}:"
    & ".\$productName\qps-license-server.exe" -deact
    if( $? ) {
            write-host "Successfully deactivated: $productName"
            Get-Service -Displayname "${productName}*floating license server" | Start-Service
            if( ! $? ) {
                    write-host "FAILED to start service for $productName"
            }
            else
            {
                    & "$productName\qps-license-server.exe" -u
            }
    } else {
            write-host "FAILED to deactivate: $productName" 
} } } else {
        write-host "No connection to Internet servers, cannot activate license.  FAILED."
        write-host "If the computer is not connected to the Internet, use the manual offline activation procedures."
        Exit
}

