param ([Parameter(Mandatory)]$product, $sub1, $sub2, $sub3)
function concatProduct( $sub ) {
  return "$product $sub"
}
if( $sub1 ) {
  $product = concatProduct( $sub1 )
}
if( $sub2 ) {
  $product = concatProduct( $sub2 )
}
if( $sub3 ) {
  $product = concatProduct( $sub3 )
}

if( -Not( Test-Path $product )) {
  write-host "No such product found: $product.  Quitting."
} else {
  $configfilename = "$product/TurboFloatServer-config.xml"
  if( -Not( Test-Path $configfilename )) {
    write-host "No XML config file for $product.  Quitting."
  } else {
    [XML]$configfile = Get-Content $configfilename
    $logfile = $configfile.config.log.file;
    if( -Not( Split-Path -Path $logfile -IsAbsolute )) {
      $logfile = "$product\$logfile"
    }
    if( -Not( Test-Path $logfile ))
    {
      Write-Host "The log file does not yet exist for: $product"
      write-host "Press Ctrl-C to exit.  Waiting."
    }
    while( -Not( Test-Path $logfile ))
    {
      Write-Host "."  -NoNewline
      Start-Sleep -Seconds 5
    }
    if( Test-Path $logfile ) {
      cls
      write-host "Listing live log data for: $product"
      write-host "Press Ctrl-C to exit listing..."
      write-host "=============================="
      Get-Content $logfile -Wait -Tail 10
    }
  }
}
